//
//  BMKWalkNaviHelper.h
//  WalkCycleComponent
//
//  Created by Xin,Qi on 24/01/2018.
//  Copyright © 2018 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BMKWalkCycleNavigationDelegates.h"
#import "BMKWalkNaviLaunchParam.h"
#import "BMKWalkCycleNavigationDisplayOption.h"
#import "BMKWalkNavigationNPCOption.h"
#import "BMKWalkCycleRouteResult.h"
#import <BaiduMapAPI_Base/BMKBaseComponent.h>

#import "BMKWalkCycleNavigationOptions.h"
@class BMKBackgroundNavigationView;
@class BMKMapView;
@class BMKPolyline;

#pragma mark - 步行导航控制器类
/// 步行导航控制器类
@interface BMKWalkNavigationManager : NSObject
/// 设置导航模式,默认：BMK_WALK_NAVIGATION_MODE_WALK_NORMAL-普通步行导航
@property (nonatomic, assign) BMKWalkNavigationMode walkNaviMode;
/// 设置导航是否显示红路灯倒计时,引擎初始化成功后调用，默认：NO，有高级权限时默认YES，since 6.6.2
@property (nonatomic, assign) BOOL showRedGreenLight;

/// 路线全览区域在mapview上的insets，since 6.5.8
@property (nonatomic, assign) UIEdgeInsets zoomToSpanInsets;

/// 设置导航地图旋转模式，默认：BMKNaviMapRotateModeRoute 路线朝上，since 6.6.2
@property (nonatomic, assign) BMKNaviMapRotateMode naviMapRotateMode;
/// 设置导航地图俯仰视角模式，默认：BMKNaviMapOverlookingMode2D 2d视角，since 6.6.2
@property (nonatomic, assign) BMKNaviMapOverlookingMode naviMapOverlookingMode;
/// 设置导航是否全览状态，默认：NO 导航态，，since 6.6.2
@property (nonatomic, assign) BOOL naviMapViewAllStatus;

/*
 导航中剩余时间距离面板底部需要预留高度,默认为0。，since 6.5.8
对于刘海屏设备，bottomButtonHeight等于【底部安全区域的顶部】 到 【导航中剩余时间距离面板的底部】的距离
对于非刘海屏设备，bottomButtonHeight等于【屏幕底部】到【导航中剩余时间距离面板的底部】的距离
 */
@property (nonatomic, assign) CGFloat bottomButtonHeight; /**< 底部需要预留高度，用于填充自身控件,默认0 */

/// 设置是否支持多路线规划选择，可在routePlanDelegate回调中处理多路线并进行绘制选择。默认NO
@property (nonatomic, assign) BOOL enableMultiRoute;

/// 多实例授权代理回调
@property (nonatomic, weak) id <BMKWalkCycleAuthorizeDelegate> authorizeDelegate;
/// 多路线规划代理回调
@property (nonatomic, weak) id <BMKWalkCycleRoutePlanDelegate> routePlanDelegate;

/// 引擎算路代理，回调成功时即可调用startWalkNaviWithParentController开始导航
@property (nonatomic, weak) id <BMKWalkNaviCalcRouteDelegate> calcRouteDelegate;

/// 导航管理回调
@property (nonatomic, weak) id <BMKWalkCycleManagerDelegate> managerDelegate;

/// 导航状态信息回调
@property (nonatomic, weak) id <BMKWalkCycleRouteGuidanceDelegate> routeGuidanceDelegate;

/// 语音播报文本回调
@property (nonatomic, weak) id <BMKWalkCycleTTSPlayerDelegate> ttsPlayerDelegate;

/// 步骑行导航定位权限授权代理，开发者在调用startWalkNavi前主动申请相关定位权限
@property (nonatomic, weak) id <BMKWalkCycleLocationServiceDelegate> locationAuthorizationDelegate;

/**
  *是否支外部传入位置，默认NO（步行室内外一体化导航时设置为YES，配合百度定位SDK由外部传入位置、、楼id，楼层、heading等信息）
  *配合triggerLocation和triggerHeading接口，实现仅外部传入位置点对导航生效，避免内部系统定位对位置点影响
  *也可用于模拟导航
  */
@property (nonatomic, assign) BOOL isSupportExternalTriggerLocation;

/// 单例全局访问点
/// @return BMKWalkNavigationManager单例对象。
+ (instancetype)sharedManager;

/// 销毁单例
+ (void)destroy;

/// 初始化引擎 方法一
/// @param controller 导航页面，由开发者提供。
/// @return 引擎初始化结果。
- (BOOL)initNaviEngine:(UIViewController *)controller;

/// 初始化引擎 方法二 since 5.3.0
/// @param controller 导航页面，由开发者提供。
/// @param displayOption 导航定制化展示相关参数。
/// @return 引擎初始化结果。
- (BOOL)initNaviEngine:(UIViewController *)controller
         displayOption:(BMKWalkCycleNavigationDisplayOption *)displayOption;

/// 初始化引擎 since 6.6.2
/// @param controller 导航页面，由开发者提供。
/// @param options 导航相关可选配置参数。
/// @return 引擎初始化结果。
- (BOOL)initNaviEngine:(UIViewController *)controller
         options:(BMKWalkCycleNavigationOptions *)options;

/// 初始化引擎 方法二
/// @param controller 导航页面，由开发者提供。
/// @param displayOption 导航定制化展示相关参数。
/// @param npcOption NPC（AR导航'3D'引导员）相关参数，如果不需要自定义AR3D引导员，可传nil,此参数设置为nil，将不显示打开导引员列表的按钮。
/// @return 引擎初始化结果
- (BOOL)initNaviEngine:(UIViewController *)controller
         displayOption:(BMKWalkCycleNavigationDisplayOption *)displayOption
             npcOption:(BMKWalkNavigationNPCOption *)npcOption;

/// 发起算路
/// @param parameter 步行导航起终点参数类
- (void)routePlanWithParams:(BMKWalkNaviLaunchParam *)parameter;

/// 获取导航多路线规划信息 since 6.6.2
/// 需要在算路规划成功(-onRoutePlanResult: naviType:)后获取，否则会为nil
- (NSArray<BMKWalkCycleRouteResult *> *)getWalkNaviMulRouteInfos;

/// 获取导航算路路线信息 since 6.6.2
/// 需要在引擎算路成功(-onNaviCalcRouteResult: naviType:)和偏航算路成功(-onReRouteComplete:)后获取，否则会为nil
- (BMKWalkCycleRouteResult *)getWalkNaviRouteInfo;

/// 获取导航过程中的位置点数据 since 6.6.2
/// 需要在导航过程中调用，否则会为nil
- (BMKWalkCycleNavigationData *)getWalkNavigationLocationData;

/// 展示步行多路线  since 6.4.0
/// @param mapview 展示路线的mapView
/// @return obj 路线BMKPolyline
- (NSArray<BMKPolyline *> *)displayRoutePlanResult:(BMKMapView *)mapview;

/// 引擎算路接口 since 6.4.0
/// @param routeIndex 路线索引
- (void)naviCalcRoute:(NSInteger)routeIndex;

/// 导航过程生命周期函数, 开始导航。已废弃 since 6.0.0
/// 选择模式不同，加载导航页面不一样，分为普通步行和AR步行两种模式。
/// @param navigationMode 步行导航模式。
/// @return 开始导航结果
- (BOOL)startWalkNavi:(BMKWalkNavigationMode)navigationMode __deprecated_msg("已废弃since 6.0.0，内部无实现，请使用- (BOOL)startWalkNavi");

- (BOOL)startWalkNavi __deprecated_msg("已废弃since 6.5.4，内部无实现，请使用- (BOOL)startWalkNavi:withParentController:isPush");

/// 导航过程生命周期函数, 开始导航。 since 6.5.4
/// 设置walkNaviMode模式的不同，加载导航页面不一样，分为轻步行导航、普通步行、AR步行三种模式。
/// @controller 父controller，用于push或present
/// @isPush 是否Push出新页面，YES：push；NO：present
/// @return 开始导航结果
- (BOOL)startWalkNaviWithParentController:(UIViewController *)controller isPush:(BOOL)isPush;

/// 退出步行专业导航，等同于点击步行专业导航退出按钮,since 6.5.8
- (void)exitWalkNomalNavi;

/// 导航过程生命周期函数, 开始轻导航,since 6.5.8
/// @param parentView  放置轻导航MapView的父view，用于展示轻导航路线
- (BOOL)startWalkLightNaviWithParentView:(UIView *)parentView;

/// 退出轻导航，当退出轻导航页面时，需要退出轻导航，since 6.5.8
- (void)exitWalkLightNavi;

/// 轻导航切换到专业导航
- (BOOL)switchToWalkNomalNaviWithParentController:(UIViewController *)controller isPush:(BOOL)isPush;

/// 轻导航一键恢复全览
- (void)returnToViewAll;

/// 进入自由态，如等待乘客阶段
- (void)enterCarFreeSatus;

/// 离开自由态
- (void)leaveCarFreeSatus;



/// 获取导航自定义图层View 
- (UIView *)getCustomNaviView;

/// 获取步行导航底图对象
- (BMKMapView *)getNaviMap;

/**
 * 获取骑行后台导航视图对象
 */
- (BMKBackgroundNavigationView *)getBackgroundNavigationView;

/// 导航过程生命周期函数，暂停导航。
- (void)pause;

/// 导航过程生命周期函数，恢复导航。
- (void)resume;

/// 导航过程生命周期函数，结束导航。
- (void)stop;

/// 设置是否显示定位指示蓝条
/// @param show YES:显示（进入后台时保留被授予的临时访问权限） NO：不显示
- (void)showsBackgroundLocationIndicator:(BOOL)show;

/// 是否是纯室内路线导航
- (BOOL)isOnlyIndoorRouteNavi;

/// 外部传入定位坐标数据
- (void)triggerLocation:(BMKUserLocation *)location;
/// 外部传入定位heading数据
- (void)triggerHeading:(CLHeading *)heading;

#pragma mark - 步行AR导航3D模型显示相关接口

/// 获取所有可用'3D'引导员资源，其中包括开发者您提供的自定义引导员以及由步骑行导航组件提供图图引导员和经典模式。
/// 可用于自定义引导员选择列表。
/// @return 所有可用引导员。
- (NSArray <BMKWalkNavigationNPCGuider *> *)fetchAllAvailableGuiders;

/// 加载显示指定的引导员
/// @param guider 指定引导员。
/// @return 返回设置结果。
- (BOOL)showGuider:(BMKWalkNavigationNPCGuider *)guider;
@end
