//
//  BMKWalkNaviRouteNodeInfo.h
//  BaiduMapAPI_WalkNavi
//
//  Created by Baidu on 2021/4/20.
//  Copyright © 2021 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <CoreLocation/CoreLocation.h>

#import "BMKWalkCycleDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface BMKWalkNaviRouteNodeInfo : NSObject
/// 经纬度，关键字，poiid三选一，与BMKWalkNavigationRouteNodeType对应,起终点类型需一致
/// 算路经纬度坐标
@property (nonatomic, assign) CLLocationCoordinate2D location;
/// 算路关键字
@property (nonatomic, copy) NSString *keyword;
/// 算路节点poiid
@property (nonatomic, copy) NSString *poiId;
/// 算路方式，多路线规划时可支持三种类型，单路线仅支持BMKWalkNavigationRouteNodeLocation类型
@property (nonatomic, assign) BMKWalkNavigationRouteNodeType type;
/// 城市ID，可选
@property (nonatomic, copy) NSString *cityId;
/// 楼层ID，可选
@property (nonatomic, copy) NSString *floorId;
/// 建筑ID，可选
@property (nonatomic, copy) NSString *buildingId;

@end

NS_ASSUME_NONNULL_END
