//
//  BMKWalkNaviLaunchParam.h
//  WalkCycleComponent
//
//  Created by Xin,Qi on 24/01/2018.
//  Copyright © 2018 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <CoreLocation/CoreLocation.h>

#import "BMKWalkCycleDefine.h"
#import "BMKWalkNaviRouteNodeInfo.h"

/// 算路起始点设置类
@interface BMKWalkNaviLaunchParam : NSObject

/// 算路起点
@property (nonatomic, assign) CLLocationCoordinate2D startPoint __deprecated_msg("已废弃since 6.4.0，请使用 startNode");

/// 算路终点
@property (nonatomic, assign) CLLocationCoordinate2D endPoint __deprecated_msg("已废弃since 6.4.0，请使用 endNode");

/// 算路起点参数 since 6.4.0
@property (nonatomic, strong) BMKWalkNaviRouteNodeInfo *startNode;

/// 算路终点参数 since 6.4.0
@property (nonatomic, strong) BMKWalkNaviRouteNodeInfo *endNode;

/// 算路途径点参数 since 6.5.2
/// 注：目前仅支持一个途经点
@property (nonatomic, copy) NSArray<BMKWalkNaviRouteNodeInfo *> *viaNodes;

@end
