//
//  BMKWalkCycleSampleGuideInfo.h
//  BaiduMapAPI_WalkNavi
//
//  Created by zhaoxiangru on 2024/3/25.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface BMKWalkCycleSampleGuideInfo : NSObject
/// 当前所在路段长度
@property (nonatomic, assign) int paragraphLength;
/// 当前路段剩余距离
@property (nonatomic, assign) int distToNextGP;
/// 是否是下个转向消息
@property (nonatomic, assign) BOOL isNextStepTurnMsg;
/// 转向时对应的路口名称，isNextStepTurnMsg为YES时有值
@property (nonatomic, copy)  NSString *nextRouteName;
/// 当前速度
@property(nonatomic,assign) CGFloat fCurrSpeed;
/// 平均速度
@property(nonatomic, assign) CGFloat fAvgSpeed;
/// 最快速度
@property(nonatomic,assign) CGFloat fMaxSpeed;
/// 累计消耗卡路里
@property(nonatomic,assign) CGFloat fCalorie;
/// 累计爬升
@property(nonatomic,assign) CGFloat fAltiDiff;
/// 当前海拔
@property(nonatomic,assign) CGFloat fAltitude;
@end

NS_ASSUME_NONNULL_END
