//
//  BMKWalkCycleNavigationDisplayOption.h
//  BaiduMapAPI_WalkNavi
//
//  Created by Xin,Qi on 2018/7/28.
//  Copyright © 2018 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BMKWalkCycleDefine.h"
#import "BMKWalkNavigationNPCGuider.h"

@class BMKWalkCycleNaviContentDisplayOption;
@class BMKWalkCycleNaviLocationDisplayOption;
@class BMKWalkCycleNaviTabBarDisplayOption;
@class BMKWalkNaviCalorieDisplayOption;
@class BMKCycleNaviZoomDisplayOption;
@class BMKCycleNaviDashboardDisplayOption;
@class BMKWalkNaviARDisplayOption;
@class BMKWalkCycleNaviDrawItemDisplayOption;

/// 步骑行导航定制化设置类。
/// 此类提供对步骑行导航页面元素和导航行为进行个性化定制的能力。
@interface BMKWalkCycleNavigationDisplayOption : NSObject

/// 导航页面右下角进入AR导航模式图标
@property (nonatomic, strong) UIImage *walkARModeIcon;

/// 导航页面右下角进入普通导航模式图标，since 6.5.2废弃，见导航页面底部tabBar 的右侧按钮图标。
@property (nonatomic, strong) UIImage *walkNormalModeIcon;

/// 步行导航页面右下角AR导航模式入口是否隐藏，默认false
@property (nonatomic, getter=isWalkARModeHidden) BOOL walkARModeHidden;

/// 是否支持结束导航自动弹窗提示，默认值为YES。
@property (nonatomic, assign) BOOL supportEndPopup;

/// 步骑行导航语言类型,英文导航需要高级权限，请联系商务或PM开通，,since 6.6.3
@property(nonatomic, assign) BMKWalkCycleNavigationLanguageType languageType;

/// 导航页面顶部诱导图层 since 5.3.0
@property (nonatomic, strong) BMKWalkCycleNaviContentDisplayOption *walkCycleNaviContentDisplayOption;

/// 导航页面左下角的导航标记 since 5.3.0
@property (nonatomic, strong) BMKWalkCycleNaviLocationDisplayOption *walkCycleNaviLocationDisplayOption;

/// 导航页面底部tabBar since 5.3.0
@property (nonatomic, strong) BMKWalkCycleNaviTabBarDisplayOption *walkCycleNaviTabBarDisplayOption;

/// 步行导航页面卡路里图层 since 5.3.0
@property (nonatomic, strong) BMKWalkNaviCalorieDisplayOption *walkNaviCalorieDisplayOption;

/// AR步行导航页面功能自定义 since 6.5.4
@property (nonatomic, strong) BMKWalkNaviARDisplayOption *walkNaviARDisplayOption;

/// 骑行导航页面的放大缩小控件 since 5.3.0
@property (nonatomic, strong) BMKCycleNaviZoomDisplayOption *cycleNaviZoomDisplayOption;

/// 骑行导航页面仪表盘控件 since 5.3.0
@property (nonatomic, strong) BMKCycleNaviDashboardDisplayOption *cycleNaviDashboardDisplayOption;

/// 步骑行导航地图元素自定义 since 6.6.3
@property (nonatomic, strong) BMKWalkCycleNaviDrawItemDisplayOption *walkCycleNaviDrawItemDisplayOption;

@end


/// 导航页面顶部诱导图层
@interface BMKWalkCycleNaviContentDisplayOption : NSObject

/// 背景色
@property (nonatomic, strong) UIColor *backgroundColor;

/// 背景图片
/// width = [UIScreen mainScreen].bounds.size.width - 20
/// height = [UIScreen mainScreen].bounds.size.width / 3.4
@property (nonatomic, strong) UIImage *backgroundIcon;


/// 诱导信息文本颜色
@property (nonatomic, strong) UIColor *guideInfoTextColor;

/// 偏导航信息文本颜色
@property (nonatomic, strong) UIColor *yaWingInfoTextColor;

/// 隐藏导航View
@property (nonatomic, assign) BOOL hideNaviContentView;

@end

/// 导航页面左下角的导航标记
@interface BMKWalkCycleNaviLocationDisplayOption : NSObject

/// 背景色
@property (nonatomic, strong) UIColor *backgroundColor;

/// 是否隐藏视图(默认NO)
@property (nonatomic, assign) BOOL hideLocation;

@end

/// 导航页面底部tabar
@interface BMKWalkCycleNaviTabBarDisplayOption : NSObject
/// 导航页面底部tabar整体可见性，默认NO：不隐藏，AR模式暂不支持 since 6.5.4
@property (nonatomic, assign) BOOL tabBarHidden;

/// 背景色
@property (nonatomic, strong) UIColor *backgroundColor;

/// 背景图片
/// width = [UIScreen mainScreen].bounds.size.width - 20
///  height = 50
@property (nonatomic, strong) UIImage *backgroundIcon;

/// 导航页面左下角退出按钮图标
@property (nonatomic, strong) UIImage *exitIcon;

/// 步行AR导航页面左下角退出按钮图标
@property (nonatomic, strong) UIImage *exitARIcon;

/// 查看全览文本颜色
@property (nonatomic, strong) UIColor *seeAllTextColor;

/// 剩余信息文本颜色
@property (nonatomic, strong) UIColor *remainInfoTextColor;

/// 继续导航文本颜色
@property (nonatomic, strong) UIColor *goOnTextColor;

@end

/// 步行导航页面卡路里图层
@interface BMKWalkNaviCalorieDisplayOption : NSObject

/// 是否隐藏卡路里视图(默认NO)
@property (nonatomic, assign) BOOL hideCalorie;

/// 背景图标
@property (nonatomic, strong) UIImage *backgroundImage;

@end

/// AR步行导航页面自定义
@interface BMKWalkNaviARDisplayOption : NSObject
/// 设置AR导航默认是否展开小地图，默认值为YES。since 6.5.4
@property (nonatomic, assign) BOOL showSmallMapViewByDefault;

/// 设置AR导航默认是否支持AR实景/平面导航手机倾斜角自动切换，默认值为NO。since 6.5.4
@property (nonatomic, assign) BOOL autoSwitchWalkModeByDefault;
@end

/// 骑行导航页面的放大缩小控件
@interface BMKCycleNaviZoomDisplayOption : NSObject

/// 是否隐藏(默认NO)
@property (nonatomic, assign) BOOL hideZoom;

/// 背景色
@property (nonatomic, strong) UIColor *backgroundColor;

/// 放大按钮图标
@property (nonatomic, strong) UIImage *zoomOutIcon;

/// 缩小按钮图标
@property (nonatomic, strong) UIImage *zoomInIcon;

/// 分割线颜色
@property (nonatomic, strong) UIColor *splitColor;

@end

/// 骑行导航页面仪表盘控件
@interface BMKCycleNaviDashboardDisplayOption : NSObject

/// 是否隐藏(默认NO)
@property (nonatomic, assign) BOOL hideDashboard;

/// 背景色
@property (nonatomic, strong) UIColor *backgroundColor;

/// 速度文本色
@property (nonatomic, strong) UIColor *speedInfoColor;

@end

/// 导航地图页面元素自定义样式
@interface BMKWalkCycleNaviDrawItemDisplayOption : NSObject
/// 罗盘
@property(nonatomic, strong) UIImage *compassImage;
/// 终点
@property(nonatomic, strong) UIImage *endPointImage;
/// 路线
@property(nonatomic, strong) UIImage *routeImage;
/// 已走过路线
@property(nonatomic, strong) UIImage *routePassedImage;
/// 路线宽度，默认15,范围5～30
@property(nonatomic, assign) NSUInteger routeWidth;
@end
