//
//  BMKWalkCycleNavigationDelegates.h
//  WalkNaviComponent
//
//  Created by Xin,Qi on 28/03/2018.
//  Copyright © 2018 Baidu. All rights reserved.
//

#ifndef BMKWalkCycleNavigationDelegates_h
#define BMKWalkCycleNavigationDelegates_h
#import <CoreLocation/CoreLocation.h>
#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BMKWalkCycleDefine.h"
#import "BMKAuthorizeServiceModel.h"
#import <BaiduMapAPI_Base/BMKTypes.h>
#import "BMKWalkCycleNavigationData.h"
#import "BMKWalkCycleSampleGuideInfo.h"
#pragma mark - 步骑行导航（多）路线规划代理类
/**
 步骑行导航（多）路线规划代理类
 */
@protocol BMKWalkCycleRoutePlanDelegate <NSObject>

@optional
/**
 开始（多）路线规划
 */
- (void)onRoutePlanStart:(BMKWalkCycleNavigationType)naviType;

/**
 （多）路线规划结果返回
 
 @param errorCode 错误码
 */
- (void)onRoutePlanResult:(BMKWalkCycleRoutePlanErrorCode)errorCode naviType:(BMKWalkCycleNavigationType)naviType;

@end

#pragma mark - 步行导航引擎算路代理

@protocol BMKWalkNaviCalcRouteDelegate <NSObject>

@optional

/// 引擎算路结果
/// @param errorCode 错误码
- (void)onNaviCalcRouteResult:(BMKWalkCycleRoutePlanErrorCode)errorCode;


/// 引擎算路结果
/// @param errorCode 错误码
/// @param naviType 导航类型
- (void)onNaviCalcRouteResult:(BMKWalkCycleRoutePlanErrorCode)errorCode naviType:(BMKWalkCycleNavigationType)naviType;

@end

#pragma mark - 步行导航管理代理类

@protocol BMKWalkCycleManagerDelegate <NSObject>

@optional
/// 退出导航
/// @param exitType 退出方式
/// @param naviType 步骑行导航类型
- (void)exitWalkCycleNaviView:(BMKNaviExitType)exitType naviType:(BMKWalkCycleNavigationType)naviType;

@end

#pragma mark - 步行导航诱导信息代理类
/**
 步骑行导航诱导信息代理类
 */
@protocol BMKWalkCycleRouteGuidanceDelegate <NSObject>

@optional
/// 步骑行导航简易诱导信息,since 6.6.2,请联系商务或PM开通
- (void)onSampleGuideInfoUpdate:(BMKWalkCycleSampleGuideInfo *_Nullable)sampleGuideInfo naviType:(BMKWalkCycleNavigationType)naviType;
/**
 诱导图标更新。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param icon 诱导图标
 */
- (void)onRouteGuideIconUpdate:(UIImage *_Nullable)icon naviType:(BMKWalkCycleNavigationType)naviType;

/** 
 诱导图标更新。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param iconName  诱导图标名称
 @param naviType  步骑行导航类型
 */
- (void)onRouteGuideIconNameUpdate:(NSString *_Nullable)iconName naviType:(BMKWalkCycleNavigationType)naviType;

/**
 诱导枚举信息。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param guideKind 诱导信息
 */
- (void)onRouteGuideKind:(BMKWalkCycleGuideKind)guideKind naviType:(BMKWalkCycleNavigationType)naviType;

/**
 诱导信息。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param firstSequence 第一行显示的信息，比如“沿当前道路”
 @param secondSequence 第二行显示的信息，比如“向东出发”，第二行信息也可能为空
 */
- (void)onRoadGuideTextUpdateFirst:(NSString *_Nullable)firstSequence second:(NSString *_Nullable)secondSequence naviType:(BMKWalkCycleNavigationType)naviType;

/**
 总的剩余时间
 
 @param remainTime 剩余时间，单位：秒,可强转为int
 */
- (void)onRemainTimeUpdate:(NSString *_Nullable)remainTime naviType:(BMKWalkCycleNavigationType)naviType;

/**
 总的剩余距离
 
 @param remainDistance 剩余距离，单位：米,可强转为int
 */
- (void)onRemainDistanceUpdate:(NSString *_Nullable)remainDistance naviType:(BMKWalkCycleNavigationType)naviType;

/**
 GPS状态发生变化，来自诱导引擎的消息
 
 @param gspInfo GPS信息
 @param guideIcon GPS诱导图标
 */
- (void)onGpsStatusChange:(NSString *_Nullable)gspInfo guideIcon:(UIImage *_Nullable)guideIcon naviType:(BMKWalkCycleNavigationType)naviType;

/**
 GPS位置发生改变，来自诱导引擎的消息
 
 @param naviData 绑路后的位置
 @param naviType 导航类型
 */
- (void)onGpsPositionUpdate:(BMKWalkCycleNavigationData *_Nullable)naviData naviType:(BMKWalkCycleNavigationType)naviType;

/**
 GPS状态发生变化，来自诱导引擎的消息。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param gspInfo                GPS信息
 @param guideIconName  GPS诱导图标名称
 @param naviType             步骑行导航类型
 */
- (void)onGpsStatusChange:(NSString *_Nullable)gspInfo guideIconName:(NSString *_Nullable)guideIconName naviType:(BMKWalkCycleNavigationType)naviType;

/**
 已经开始偏航
 
 @param rarAwayInfo 偏航信息
 @param guideIcon 偏航诱导图标
 */
- (void)onRouteFarAway:(NSString *_Nullable)rarAwayInfo guideIcon:(UIImage *_Nullable)guideIcon naviType:(BMKWalkCycleNavigationType)naviType;

/**
 已经开始偏航。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param rarAwayInfo      偏航信息
 @param guideIconName 偏航诱导图标名称
 @param naviType            步骑行导航类型
 */
- (void)onRouteFarAway:(NSString *_Nullable)rarAwayInfo guideIconName:(NSString *_Nullable)guideIconName naviType:(BMKWalkCycleNavigationType)naviType;

/**
 偏航规划中
 
 @param yawingInfo 偏航规划中的信息
 @param guideIcon 偏航诱导图标
 */
- (void)onRoutePlanYawing:(NSString *_Nullable)yawingInfo guideIcon:(UIImage *_Nullable)guideIcon naviType:(BMKWalkCycleNavigationType)naviType;

/**
 偏航规划中。增加高级权限控制,since 6.6.2,请联系商务或PM开通
 
 @param yawingInfo       偏航规划中的信息
 @param guideIconName 偏航诱导图标名称
 @param naviType            步骑行导航类型
 */
- (void)onRoutePlanYawing:(NSString *_Nullable)yawingInfo guideIconName:(NSString *_Nullable)guideIconName naviType:(BMKWalkCycleNavigationType)naviType;

/**
 重新算路成功
 */
- (void)onReRouteComplete:(BMKWalkCycleNavigationType)naviType;

/**
 重新算路失败
 */
- (void)onReRouteFail:(BMKWalkCycleNavigationType)naviType;

/**
 到达目的地
 */
- (void)onArriveDest:(BMKWalkCycleNavigationType)naviType;

/**
 室内到达目的地
 */
- (void)onIndoorArriveDest:(BMKWalkCycleNavigationType)naviType;

/**
 室外到达目的地
 */
- (void)onOutdoorArriveDest:(BMKWalkCycleNavigationType)naviType;

/**
 震动
 */
- (void)onVibrate:(BMKWalkCycleNavigationType)naviType;

@end

#pragma mark - 步行导航TTS语音播报代理类
/**
 步骑行导航TTS语音播报代理类
 */
@protocol BMKWalkCycleTTSPlayerDelegate <NSObject>

@optional

/**
 诱导文本回调
 
 @param text 诱导文本
 @param prior 是否抢先播报
 */
- (void)onPlayTTSText:(NSString *_Nullable)text prior:(BOOL)prior naviType:(BMKWalkCycleNavigationType)naviType;

@end

@protocol BMKWalkCycleLocationServiceDelegate <NSObject>
@optional
/**
 *  @brief 为了适配app store关于新的后台定位的审核机制（app store要求如果开发者只配置了使用期间定位，则代码中不能出现申请后台定位的逻辑），当开发者在plist配置NSLocationAlwaysUsageDescription或者NSLocationAlwaysAndWhenInUseUsageDescription时，需要在该delegate中调用后台定位api：[locationManager requestAlwaysAuthorization]。开发者如果只配置了NSLocationWhenInUseUsageDescription，且只有使用期间的定位需求，则无需在delegate中实现逻辑。
 *  @param locationManager 系统 CLLocationManager 类 。
 *  @since 5.0.0
 */
- (void)doRequestAlwaysAuthorization:(CLLocationManager * _Nonnull)locationManager DEPRECATED_MSG_ATTRIBUTE("定位权限需要开发者主动申请");

/**
 步骑行导航定位服务错误码
 
 @param errorCode 错误对象
 */
- (void)onLocationServiceError:(BMKWalkCycleNavigationLocationServiceErrorCode)errorCode;

@end

#pragma mark - 步行导航多实例授权代理类
/**
 步行导航多实例授权代理类
 */
@protocol BMKWalkCycleAuthorizeDelegate <NSObject>

@optional
/**
 多实例授权回调，授权失败时会自动解除多实例数据绑定
 */
- (void)onMultiNaviViewInstanceAuthorizeWithError:(BMKLicenseServiceErrorCode)errorCode serviceType:(BMKAuthorizeServiceType)serviceType;

@end
#endif /* BMKWalkCycleNavigationDelegates_h */
