//
//  BMKMultiNaviView.h
//  BaiduMapAPI_WalkNavi
//
//  Created by zhaoxiangru on 2024/1/5.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BMKWalkCycleDefine.h"
#import "BMKAuthorizeServiceModel.h"

NS_ASSUME_NONNULL_BEGIN
@class BMKMapView;
/// 多实例导航视图
@interface BMKMultiNaviView : UIView
/// 导航类型,默认步行
@property (nonatomic, assign, readonly) BMKWalkCycleNavigationType naviType;
/// 导航地图唯一标识，默认为当前对象hash值的字符串
@property (nonatomic, copy) NSString *tagString;
/// 设置默认比例尺，默认：17,范围：4～22
@property (nonatomic, assign) float defaultNaviMapLevel;
/// 设置导航地图旋转模式，默认：BMKNaviMapRotateModeRoute 路线朝上
@property (nonatomic, assign) BMKNaviMapRotateMode naviMapRotateMode;
/// 设置导航地图俯仰视角模式，默认：BMKNaviMapOverlookingMode2D 2d视角
@property (nonatomic, assign) BMKNaviMapOverlookingMode naviMapOverlookingMode;

/// 设置导航是否全览状态，默认：NO 导航态，暂不支持
@property (nonatomic, assign) BOOL naviMapViewAllStatus;
/// 设置全览下路线展示区域相对地图的insets ，默认：{0,0,0,0}，暂不支持
@property (nonatomic, assign) UIEdgeInsets naviMapInsets;

/// 绑定多实例导航数据源
- (BOOL)bindNaviDataSourceWithNaviType:(BMKWalkCycleNavigationType)naviType;
/// 获取MapView
- (BMKMapView *)getNaviMapView;
/// 恢复导航地图实例。
- (void)onResume;
/// 暂停导航地图实例。
- (void)onPause;
/// 销毁导航地图实例内部持有（并解除绑定多实例导航数据源）。
- (void)onDestroy;
@end

NS_ASSUME_NONNULL_END
