//
//  BMKCycleNaviHelper.h
//  CycleComponent
//
//  Created by Xin,Qi on 24/01/2018.
//  Copyright © 2018 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "BMKWalkCycleNavigationDelegates.h"

#import "BMKWalkCycleDefine.h"
#import "BMKCycleNaviLaunchParam.h"
#import "BMKWalkCycleNavigationOptions.h"
#import <BaiduMapAPI_Base/BMKBaseComponent.h>
#import "BMKWalkCycleNavigationDisplayOption.h"
#import "BMKWalkCycleRouteResult.h"

@class BMKBackgroundNavigationView;
@class BMKMapView;
@class BMKPolyline;

#pragma mark - 骑行导航控制器类
/**
 骑行导航控制器类
 */
@interface BMKCycleNavigationManager : NSObject

/// 骑行导航模式，目前支持普通骑行导航、骑行轻导航
@property (nonatomic, assign) BMKCycleNavigationMode cycleNaviMode;

/// 路线全览区域在mapview上的insets，since 6.5.8
@property (nonatomic, assign) UIEdgeInsets zoomToSpanInsets;
/// 设置导航地图旋转模式，默认：BMKNaviMapRotateModeRoute 路线朝上，since 6.6.2
@property (nonatomic, assign) BMKNaviMapRotateMode naviMapRotateMode;
/// 设置导航地图俯仰视角模式，默认：BMKNaviMapOverlookingMode2D 2d视角，since 6.6.2
@property (nonatomic, assign) BMKNaviMapOverlookingMode naviMapOverlookingMode;

/// 设置导航是否全览状态，默认：NO 导航态，，since 6.6.2
@property (nonatomic, assign) BOOL naviMapViewAllStatus;
/// 设置导航是否显示红路灯倒计时，引擎初始化成功后调用，默认：NO，有高级权限时默认YES，since 6.6.2
@property (nonatomic, assign) BOOL showRedGreenLight;
/// 设置是否支持多路线规划选择，可在routePlanDelegate回调中处理多路线并进行绘制选择。默认NO
@property (nonatomic, assign) BOOL enableMultiRoute;

//最大值为BMKWalkMaxBottomButtonHeight，70
/*
 导航中剩余时间距离面板底部需要预留高度,默认为0。，since 6.5.8
对于刘海屏设备，bottomButtonHeight等于【底部安全区域的顶部】 到 【导航中剩余时间距离面板的底部】的距离
对于非刘海屏设备，bottomButtonHeight等于【屏幕底部】到【导航中剩余时间距离面板的底部】的距离
 */
@property (nonatomic, assign) CGFloat bottomButtonHeight; /**< 底部需要预留高度，用于填充自身控件,默认0 */

/// 多实例授权代理回调
@property (nonatomic, weak) id <BMKWalkCycleAuthorizeDelegate> authorizeDelegate;
/**
 多路线规划代理回调
 */
@property (nonatomic, weak) id <BMKWalkCycleRoutePlanDelegate> routePlanDelegate;

/**
 算路代理回调，成功时即可调用startCycleNaviWithParentController开始导航
 */
@property (nonatomic, weak) id <BMKWalkNaviCalcRouteDelegate> calcRouteDelegate;

/**
 导航管理回调
 */
@property (nonatomic, weak) id <BMKWalkCycleManagerDelegate> managerDelegate;

/**
 导航状态信息回调
 */
@property (nonatomic, weak) id <BMKWalkCycleRouteGuidanceDelegate> routeGuidanceDelegate;

/**
 语言播报文本回调
 */
@property (nonatomic, weak) id <BMKWalkCycleTTSPlayerDelegate> ttsPlayerDelegate;

/**
  步骑行导航定位权限授权代理，开发者在调用startWalkNavi前主动申请相关定位权限
  */
@property (nonatomic, weak) id <BMKWalkCycleLocationServiceDelegate> locationAuthorizationDelegate;

/**
  *是否支外部传入位置，默认NO
  *配合triggerLocation和triggerHeading接口，实现仅外部传入位置点对导航生效，避免内部系统定位对位置点影响
  *可用于模拟导航
  */
@property (nonatomic, assign) BOOL isSupportExternalTriggerLocation;

/**
 单例全局访问点
 
 @return BMKCycleNavigationManager单例对象
 */
+ (instancetype)sharedManager;

/**
 销毁单例
 */
+ (void)destroy;

/**
 初始化引擎

 @param controller 目的导航控制器
 @param option 设置导航定制化参数。
 @return 引擎初始化结果
 */
- (BOOL)initNaviEngine:(UIViewController *)controller option:(BMKWalkCycleNavigationDisplayOption *)option;

/// 初始化引擎 since 6.6.2
/// @param controller 导航页面，由开发者提供。
/// @param options 导航相关可选配置参数。
/// @return 引擎初始化结果。
- (BOOL)initNaviEngine:(UIViewController *)controller
         options:(BMKWalkCycleNavigationOptions *)options;
/**
 发起算路
 
 @param parameter 骑行导航起终点参数类
 */
- (void)routePlanWithParams:(BMKCycleNaviLaunchParam *)parameter;

/// 展示骑行多路线  since 6.6.2
/// @param mapview 展示路线的mapView
/// @return obj 路线BMKPolyline
- (NSArray<BMKPolyline *> *)displayRoutePlanResult:(BMKMapView *)mapview;

/// 引擎算路接口，用于多路线选路进行导航 since 6.6.2
/// @param routeIndex 路线索引
- (void)naviCalcRoute:(NSInteger)routeIndex;

/// 获取骑行导航多路线规划信息 since 6.6.2
/// 需要在算路规划成功(-onRoutePlanResult: naviType:)后获取，否则会为nil
- (NSArray<BMKWalkCycleRouteResult *> *)getCycleNaviMulRouteInfos;

/**
 获取导航算路路线信息 since 6.6.2
 需要在引擎算路成功(-onNaviCalcRouteResult: naviType:)和偏航算路成功(-onReRouteComplete:)后获取，否则会为nil
  */
- (BMKWalkCycleRouteResult *)getCycleNaviRouteInfo;


/**
 获取导航过程中的位置点数据 since 6.6.2
 需要在导航过程中调用，否则会为nil
  */
- (BMKWalkCycleNavigationData *)getCycleNavigationLocationData;


/**
 导航过程生命周期函数, 开始导航

 @return 开始导航结果
 */
- (BOOL)startCycleNavi __deprecated_msg("已废弃since 6.5.4，内部无实现，请使用- (BOOL)startCycleNaviWithParentController:isPush");

/**
 导航过程生命周期函数, 开始导航,since 6.5.2
 @controller 父controller，用于push或present
 @isPush 是否Push出新页面，YES：push；NO：present
 @return 开始导航结果
 */
- (BOOL)startCycleNaviWithParentController:(UIViewController *)controller isPush:(BOOL)isPush;

/// 退出骑行专业导航，等同于点击骑行专业导航退出按钮,since 6.5.8
- (void)exitCycleNomalNavi;

/// 导航过程生命周期函数, 开始轻导航,since 6.5.8
/// @param parentView  放置轻导航MapView的父view，用于展示轻导航路线
- (BOOL)startCycleLightNaviWithParentView:(UIView *)parentView;

/// 退出轻导航，当退出轻导航页面时，需要退出轻导航，since 6.5.8
- (void)exitCycleLightNavi;

/// 轻导航切换到专业导航,since 6.5.8
- (BOOL)switchToCycleNomalNaviWithParentController:(UIViewController *)controller isPush:(BOOL)isPush;

/// 轻导航一键恢复全览,since 6.5.8
- (void)returnToViewAll;

/// 进入自由态，如等待乘客阶段,since 6.5.8
- (void)enterCarFreeSatus;

/// 离开自由态,since 6.5.8
- (void)leaveCarFreeSatus;

/**
 * 获取骑行导航底图对象
 */
- (BMKMapView *)getNaviMap;

/**
 * 获取骑行后台导航视图对象
 */
- (BMKBackgroundNavigationView *)getBackgroundNavigationView;

/// 获取导航自定义图层View,since 6.5.8
- (UIView *)getCustomNaviView;

/**
 导航过程生命周期函数, 暂停导航
 */
- (void)pause;

/**
 导航过程生命周期函数, 恢复导航
 */
- (void)resume;

/**
 导航过程生命周期函数, 结束导航
 */
- (void)stop;

/**
 设置是否显示定位指示蓝条

 @param show YES:显示（进入后台时保留被授予的临时访问权限） NO：不显示
 */

- (void)showsBackgroundLocationIndicator:(BOOL)show;

/// 外部传入定位坐标数据
- (void)triggerLocation:(BMKUserLocation *)location;
/// 外部传入定位heading数据
- (void)triggerHeading:(CLHeading *)heading;
@end
