//
//  BMKCycleNaviRouteNodeInfo.h
//  BaiduMapAPI_WalkNavi
//
//  Created by v_wangdachuan on 2023/10/27.
//  Copyright © 2023 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <CoreLocation/CoreLocation.h>

#import "BMKWalkCycleDefine.h"
NS_ASSUME_NONNULL_BEGIN

/// since 6.6.0骑行引擎算路支持传入poiid
@interface BMKCycleNaviRouteNodeInfo : NSObject
/// 算路经纬度坐标，必选
@property (nonatomic, assign) CLLocationCoordinate2D location;
/// 算路关键字  暂不支持传入关键字
@property (nonatomic, copy) NSString *keyword;
/// 算路节点poiid ，在已知起点POI 的 id 情况下，请尽量填写poiId，将提升路线规划的准确性
@property (nonatomic, copy) NSString *poiId;
/// 算路方式，目前仅支持BMKWalkNavigationRouteNodeLocation类型（骑行暂时不支持多路线算路）
@property (nonatomic, assign) BMKWalkNavigationRouteNodeType type;
@end

NS_ASSUME_NONNULL_END
