//
//  BMKCycleNaviLaunchParam.h
//  WalkCycleComponent
//
//  Created by Xin,Qi on 24/01/2018.
//  Copyright © 2018 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreLocation/CoreLocation.h>
#import "BMKWalkCycleDefine.h"
#import "BMKCycleNaviRouteNodeInfo.h"

/// 算路起始点设置类
@interface BMKCycleNaviLaunchParam : NSObject

/// 算路起点
@property (nonatomic, assign) CLLocationCoordinate2D startPoint __deprecated_msg("已废弃since 6.6.0，请使用 startNode");

/// 算路终点
@property (nonatomic, assign) CLLocationCoordinate2D endPoint  __deprecated_msg("已废弃since 6.6.0，请使用 endNode");;

/// 骑行类型，分别为普通骑行，电动车骑行
@property (nonatomic, assign) BMKWalkCycleNavigationType naviType;

/// 算路起点参数 since 6.6.0
@property (nonatomic, strong) BMKCycleNaviRouteNodeInfo *startNode;

/// 算路终点参数 since 6.6.0
@property (nonatomic, strong) BMKCycleNaviRouteNodeInfo *endNode;

/// 算路途径点参数 since 6.6.0
/// 注：目前仅支持一个途经点
@property (nonatomic, copy) NSArray<BMKCycleNaviRouteNodeInfo *> *viaNodes;
///算路路线偏好参数
/// 默认为0代表智能推荐路线  3代表规避逆行
@property (nonatomic, copy) NSString *roadPrefer;

@end
