//
//  BMKAuthorizeServiceModel.h
//  BaiduMapAPI_WalkNavi
//
//  Created by zhaoxiangru on 2023/12/22.
//  Copyright © 2023 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSUInteger, BMKAuthorizeServiceType) {
    BMKAuthorizeServiceTypeWalkNaviMulti = 0, /// 步行服务
    BMKAuthorizeServiceTypeRidingNaviMulti = 1 /// 骑行服务：自行车、电动车
};

/// nerwork 状态码
typedef NS_ENUM(NSUInteger, BMKLicenseServiceErrorCode) {
   BMK_LICENSE_SERVICE_NO_ERROR = 0,          ///< 正常返回
   BMK_LICENSE_SERVICE_INNER_ERROR,           ///< 服务内部错误
   BMK_LICENSE_SERVICE_PARAMETER_ERROR,       ///< 参数错误
   BMK_LICENSE_SERVICE_MODE_ERROR = 3,        ///< 没有设置型号
   BMK_LICENSE_SERVICE_NO_QUOTA,              ///< 没有quota
   BMK_LICENSE_SERVICE_QUOTA_NO_ENOUGH,       ///< quota不够
   BMK_LICENSE_SERVICE_QUOTA_INVALID = 6,     ///< quota无效
   BMK_LICENSE_SERVICE_NETWOKR_ERROR = 100,   ///< 网络错误
   BMK_LICENSE_SERVICE_NETWOKR_TIMEOUT,       ///< 网络连接超时
   BMK_LICENSE_SERVICE_SERVER_ERROR,          ///< 服务器错误
   BMK_LICENSE_SERVICE_NO_PERMISSION = 200,   ///< 无相关高级权限,请联系商务或PM开通
   BMK_LICENSE_SERVICE_LICENSE_STATUS_ERROR,   ///< lincese授权状态失败
   BMK_LICENSE_SERVICE_LICENSE_SIGN_ERROR,   ///< lincese验签失败
   BMK_LICENSE_SERVICE_UNKNOWN_ERROR = 1000   ///< 未知错误
};

@interface BMKAuthorizeUserInfo : NSObject
/// AK信息，默认为SDK鉴权时传入的AK
@property(nonatomic, copy, readonly) NSString *ak;
/// 设备ID信息，默认为BMKCommonInfo中的互联设备ID信息shareDeviceID
@property(nonatomic, copy) NSString *deviceID;
@end

@interface BMKAuthorizeServiceResult : NSObject
/// 授权状态
@property(nonatomic, assign) BOOL authorizeStatus;
/// license校验是否通过
@property(nonatomic, assign) BOOL licenseVerification;
@end

typedef void(^BMKAuthorizeCompletionBlock)(BMKAuthorizeServiceResult* _Nullable result, BMKLicenseServiceErrorCode errorCode);

NS_ASSUME_NONNULL_END
