//
//  BMKGeoCodeSearchOption.h
//  SearchComponent
//  本文件中包含了 正/反地理编码服务 的请求参数信息类
//  
//  Created by Baidu on 2018/5/8.
//  Copyright © 2018年 Baidu. All rights reserved.
//

#import <CoreLocation/CoreLocation.h>
#import <BaiduMapAPI_Base/BMKTypes.h>

typedef enum {
    BMKReverseGeoSortTypeDefault = 0,    ///< 默认
    BMKReverseGeoSortTypeDistance = 2,    ///< 距离
    BMKReverseGeoSortTypeRank = 3,      ///< 重要性
}BMKReverseGeoSortType;

#pragma mark - GC请求参数类
/// 正地理编码参数信息类
@interface BMKGeoCodeSearchOption : NSObject
/**
 待解析的地址。必选。
 可以输入2种样式的值，分别是：
 1、标准的结构化地址信息，如北京市海淀区上地十街十号 【推荐，地址结构越完整，解析精度越高】
 2、支持“*路与*路交叉口”描述方式，如北一环路和阜阳路的交叉路口
 注意：第二种方式并不总是有返回结果，只有当地址库中存在该地址描述时才有返回。
 */
@property (nonatomic, copy) NSString *address;
/**
 地址所在的城市名。可选。
 用于指定上述地址所在的城市，当多个城市都有上述地址时，该参数起到过滤作用。
 注意：指定该字段，不会限制坐标召回城市。
 */
@property (nonatomic, copy) NSString *city;
@end


#pragma mark - RGC请求参数类
/// 反地理编码参数信息类
@interface BMKReverseGeoCodeSearchOption : NSObject
/// 待解析的经纬度坐标（必选）
@property (nonatomic, assign) CLLocationCoordinate2D location;
/// 是否访问最新版行政区划数据（仅对中国数据生效）
@property (nonatomic, assign) BOOL isLatestAdmin;
/// 设置POI召回半径，允许设置区间为0-1000米，超过1000米按1000米召回，默认为1000米
@property (nonatomic, assign) int radius;
/// poi类型，多个用","分隔。举例：美食,酒店
@property (nonatomic, copy) NSArray<NSString *> *tags;
/// 当取值为true时，召回坐标周围最近的3条道路数据。默认NO
@property (nonatomic, assign) BOOL extensionsRoad;
/// 设置该参数可召回更多POI，优化 formatted_address_poi的结果， 与sort_strategy参数配合使用效果更佳, 默认：0  开启：1
@property (nonatomic, assign) int entirePoi;
/// 配合entire_poi使用，可选择distance距离、rank重要性、default 综合排序三个参数进行对POI结果排序 （排序影响formatted_address_poi的结果）
@property (nonatomic, assign) BMKReverseGeoSortType sortStrategy;
/// 设置每页容量，允许设置区间为0-100，默认为10条
@property (nonatomic, assign) int pageSize;
/// 分页编号
@property (nonatomic, assign) int pageNum;
/// 可选。语言类型，默认中文。
@property (nonatomic, assign) BMKLanguageType languageType;
@end



