//
//  BMKInterpolator.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/12.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// 插值器类型
typedef enum : NSUInteger {
    /**
     *  线性插值，@Default。
     */
    BMKLinearInterpolator = 1,
    /**
     *  余弦函数的半个周期，起点和终点增长缓慢，而中间快速增长。
     */
    BMKAccelerateDecelerateInterpolator,
    /**
     *  返回input的n次幂，即抛物线的右半部分，起点缓慢，然后加速。
     */
    BMKAccelerateInterpolator,
    /**
     *  返回input的n次幂，即抛物线的右半部分，起点缓慢，然后加速。
     */
    BMKDecelerateInterpolator,
    /**
     * mTension默认值为2，因此下图也是按照mTension为2来绘制的。起点的时候回往回一定值，而后再往前。
     */
    BMKAnticipateInterpolator,
    /**
     *  返回input的n次幂，即抛物线的右半部分，起点缓慢，然后加速。
     */
    BMKOvershootInterpolator,
    /**
     *  起点往回一定值，然后往前，到终点再超出一定值，然后返回。
     */
    BMKAnticipateOvershootInterpolator,
    /**
     *  类似于球掉落地面的效果。
     */
    BMKBounceInterpolator,
    /**
     *  正弦曲线， 循环播放mCycles次.
     */
    BMKCycleInterpolator,
} BMKInterpolatorType;

@interface BMKInterpolator : NSObject
+ (instancetype)linearInterpolator;

+ (instancetype)interpolatorWithType:(BMKInterpolatorType)type;

+ (instancetype)accelerateInterpolatorWithFactor:(float)factor;

+ (instancetype)decelerateInterpolatorWithFactor:(float)factor;

+ (instancetype)anticipateInterpolatorWithTension:(float)tension;

+ (instancetype)anticipateOvershootInterpolatorWithTension:(float)tension extraTension:(float)extra;

+ (instancetype)cycleInterpolatorWithCycles:(float)cycle;

+ (instancetype)overshootInterpolatorWithTension:(float)tension;
@end

NS_ASSUME_NONNULL_END
