//
//  BMKCommonDef.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/12.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  绘制元素位于「基准Anchor」的方位；
 *
 *  如果是Marker，则是Marker位于坐标点Pt的方位。
 *  如果是RichView，则是RichView位于Marker的方位。
 */
typedef enum : NSUInteger {
    // 相对于基准点的方位
    BMKLocateCenter      = (0x1 << 0),       //   Center_X & Center_Y
    BMKLocateTop         = (0x1 << 1),       //      Top_Y & Center_X
    BMKLocateBottom      = (0x1 << 2),       //   Bottom_Y & Center_X
    BMKLocateLeft        = (0x1 << 3),       //     Left_X & Center_Y
    BMKLocateRight       = (0x1 << 4),       //    Right_X & Center_Y
    
    BMKLocateLeftTop     = (BMKLocateLeft  | BMKLocateTop),     //  Left_X  & Top_Y
    BMKLocateLeftBottom  = (BMKLocateLeft  | BMKLocateBottom),  //  Left_X  & Bottom_Y
    BMKLocateRightTop    = (BMKLocateRight | BMKLocateTop),     //  Right_X & Top_Y
    BMKLocateRightBottom = (BMKLocateRight | BMKLocateBottom),  //  Right_X & Bottom_Y
    
    // 相对于基准点的 1/2 处
    BMKLocateHalfTop         = (0x1 << 10),      //    Top_Y/2 & Center_X
    BMKLocateHalfBottom      = (0x1 << 11),      // Bottom_Y/2 & Center_X
    BMKLocateHalfLeft        = (0x1 << 12),      //   Left_X/2 & Center_Y
    BMKLocateHalfRight       = (0x1 << 13),      //  Right_X/2 & Center_Y
    
    BMKLocateHalfLeftTop     = (BMKLocateHalfLeft  | BMKLocateHalfTop),     //  HalfLeft_X  & HalfTop_Y
    BMKLocateHalfLeftBottom  = (BMKLocateHalfLeft  | BMKLocateHalfBottom),  //  HalfLeft_X  & HalfBottom_Y
    BMKLocateHalfRightTop    = (BMKLocateHalfRight | BMKLocateHalfTop),     //  HalfRight_X & HalfTop_Y
    BMKLocateHalfRightBottom = (BMKLocateHalfRight | BMKLocateHalfBottom),  //  HalfRight_X & HalfBottom_Y

    // 与基准点对齐
    BMKLocateAlignTop         = (0x1 << 20),      // the same Top_Y as Anchor
    BMKLocateAlignBottom      = (0x1 << 21),      // the same Bottom_Y as Anchor
    BMKLocateAlignLeft        = (0x1 << 22),      // the same Left_X as Anchor
    BMKLocateAlignRight       = (0x1 << 23),      // the same Right_X as Anchor
    
    BMKLocateAlignLeftTop     = (BMKLocateAlignLeft  | BMKLocateAlignTop),     //  AlignLeft_X  & AlignTop_Y
    BMKLocateAlignLeftBottom  = (BMKLocateAlignLeft  | BMKLocateAlignBottom),  //  AlignLeft_X  & AlignBottom_Y
    BMKLocateAlignRightTop    = (BMKLocateAlignRight | BMKLocateAlignTop),     //  AlignRight_X & AlignTop_Y
    BMKLocateAlignRightBottom = (BMKLocateAlignRight | BMKLocateAlignBottom),  //  AlignRight_X & AlignBottom_Y

//    BMKLocateAlignAuto   = (0x1 << 30),
} BMKLocate;


/**
 *  碰撞和避让的行为
 *
 *  Note: 碰撞（Collision）：优先级低的点会被'碰掉'
 *        避让（Dodge）    ：仅是避让，不会被碰掉
 */
typedef enum : NSUInteger {
    BMKCollisionNotCollide       = (0),          // 不参与碰撞
    BMKCollisionAlwaysShow       = (0x1 << 0),   // 参与碰撞，但强制显示
    BMKCollisionHideByPriority   = (0x1 << 1),   // 参与碰撞，根据碰撞优先级决定是否显示
    BMKCollisionWithInner        = (0x1 << 2),   // BmLayer内部点碰撞
    BMKCollisionWithBasePoi      = (0x1 << 3),   // BmLayer与底图的POI进行碰撞，碰掉底图的POI
    // BmLayer内部的点先碰撞，再与底图的POI进行碰撞，最后碰掉底图的POI
    BMKCollisionInnerAndBasePoi  = (BMKCollisionWithInner | BMKCollisionWithBasePoi),
    BMKDodgeWithInner            =  (0x1 << 4),  // BmLayer内部点避让
//    BMKDodgeWithBasePoi          =  (0x1 << 5),  // BmLayer与底图的POI进行避让（暂未实现）
    // BmLayer内部点先避让，再与底图的POI进行碰撞，碰掉底图的POI（暂未实现）
//    BMKDodgeInnerAndBasePoi      =  (bmkMapDodgeWithInner | bmkMapDodgeWithBasePoi),
    BMKCollisionExceptSelf       =   (0x1 << 6),  // 当前要素不参与碰撞, marker和richview可分别设置为不参与碰撞
//    BMKCollisionBetweenBmLayer   =   (0x1 << 7),  // 仅BmLayer之间的POI碰，不与底图碰（暂未实现）
//    BMKCollisionWithBasePoiByPriority     =   (0x1 << 8),  // 当前BmLayer与底图的POI按优先级碰（暂未实现）
    BMKCollisionWithAllLayersByPriority      =   (0x1 << 9),  // 所有图层都碰撞，按优先级碰
} BMKCollisionBehavior;

/**
 *  轨迹动画，跟随
 */
typedef enum : NSUInteger {
    BMKAnimationTrackNone      = (0x00),
    BMKAnimationTrackX         = (0x01 << 0),  // 跟随X方向
    BMKAnimationTrackY         = (0x01 << 1),  // 跟随Y方向
    BMKAnimationTrackXY        = (BMKAnimationTrackX | BMKAnimationTrackY),  // 跟随(X, Y)
    BMKAnimationTrackForward   = (0x01 << 5),  // 线段的Forward，而不是行进的Forward
    BMKAnimationTrackBackward  = (0x01 << 6),  // 线段的Backward，而不是行进的Backward
} BMKAnimationTrack;

/**
 *  对Marker旋转，起作用的方式
 */
typedef enum : NSUInteger {
    // 二者能只能设置其一
    BMKRotateAnmination  = (0x1 << 0),   /** 使用动画Rotate，(Default) */
    BMKRotateItem        = (0x1 << 1),   /** 使用外部设置的Rotate */
    
    // 二者能只能设置其一
    BMKRotateScreenUpper = (0x1 << 2),   /** 旋转基准是屏幕正上方 (Default)*/
    BMKRotateGeoNorth    = (0x1 << 3),   /** 旋转基准是地理北方向*/
    
    // 二者能只能设置其一
    BMKRotateFlipNo      = (0x1 << 4),   /** 不翻转2D图片 (Default) */
    BMKRotateFlipUpper   = (0x1 << 5),   /** 翻转2D图片 */
    
    // Default
    BMKRotateFreeze     = BMKRotateAnmination | BMKRotateScreenUpper | BMKRotateFlipNo,
} BMKRotateFeature;

/**
 *   *  跟随地图的旋转轴
 */
typedef enum : NSUInteger {
    BMKFollowMapRotateAxisNone    = (0x00),       /** Default */
    BMKFollowMapRotateAxisPitch   = (0x1 << 0),   /** 对应 MapStatus._Overlooking */
    BMKFollowMapRotateAxisYaw     = (0x1 << 1),   /** 对应 MapStatus._Rotation */
} BMKRotateAxis;


NS_ASSUME_NONNULL_END
