//
//  BMKBackgroundMapView.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/2/29.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "BMKBackgroundRoadNetView.h"
#import "BMKBackgroundNavigationView.h"
#import "BMKMapView.h"

NS_ASSUME_NONNULL_BEGIN
/// 进入后台或锁屏时的地图渲染View，配合后台保活和关联源地图BMKMapView用于后台投屏，
@interface BMKBackgroundMapView : UIView
/// 关联源地图，用于同步数据
@property (nonatomic, weak) BMKMapView *mapview;
/// 帧率控制，默认30帧/s，范围10～60帧/s
@property (nonatomic, assign) NSInteger frameRate;
/// 设置地图额外偏移量,x轴负值向左偏，y轴负值向上偏，默认地图中心点targetScreenPt，可用于微调小车位置等
@property (nonatomic, assign) CGPoint mapScreenExtOffset;
/// 3D绘制，默认YES
@property (nonatomic, assign) BOOL enable3D;
/// 当前是否在渲染
@property (nonatomic, readonly) BOOL isRendering;
/// 当前适配后缩放比例
@property (nonatomic, readonly) CGFloat fitScale;
/// 获取背景图层,用于自定义背景颜色
@property (nonatomic, readonly) UIView *backgroundView;
/// 获取路网图层，用于自定义路网颜色
@property (nonatomic, readonly) BMKBackgroundRoadNetView *roadNetView;
/// 获取导航图层,用于自定义导航路线宽度，颜色（驾车导航路线路况颜色，走过置灰或擦除，置灰颜色），路线数据更新；
/// 用于自定义导航小车图标及大小，位置方向更新，罗盘是否显示，小车车头是否跟随手机旋转
@property (nonatomic, weak) BMKBackgroundNavigationView *navigationView;
/// logo位置，默认BMKLogoPositionLeftBottom
@property (nonatomic, assign) BMKLogoPosition logoPosition;
/// 开始渲染
- (void)startRender;
/// 结束渲染
- (void)stopRender;
/// 截屏
- (nullable UIImage *)takeSnapshot:(CGRect)rect;
@end

NS_ASSUME_NONNULL_END
