/*
 *  BMKArclineView.h
 *  BMapKit
 *
 *  Copyright 2011 Baidu Inc. All rights reserved.
 *
 */

#import "BMKGeometryView.h"
#import "BMKArcline.h"

NS_ASSUME_NONNULL_BEGIN
/// 此类用于定义一个圆弧View
@interface BMKArclineView : BMKGeometryView

/// 根据指定的弧线生成一个圆弧View
/// @param arcline 指定的弧线数据对象
/// @return 新生成的弧线View
- (nullable instancetype)initWithArcline:(BMKArcline *)arcline;

/// 该View对应的圆弧数据对象
@property (nonatomic, readonly) BMKArcline *arcline;

/// 是否可点击，默认NO
@property (assign, nonatomic) BOOL isClickable;

/// 发光模式，仅支持颜色实折线；since 6.6.3
/// 默认不发光，kBMKLineBloomModeNone
@property (nonatomic, assign) BMKLineBloomMode lineBloomMode;

/// 默认向两侧发光，kBMKLineBloomDirectionAround； since 6.6.3
@property (nonatomic, assign) BMKLineBloomDirection lineBloomDirection;

/// 发光处宽度，默认 0.0f；since 6.6.3
@property (nonatomic, assign) CGFloat lineBloomWidth;

/// 发光处透明度，取值范围 [0 ~ 255]，默认 255.0f；since 6.6.3
@property (nonatomic, assign) CGFloat lineBloomAlpha;

/// 透明度渐变速度 since 6.6.3
/// 取值范围 [1.0f ~ 10.0f]，默认值为 5.0f
/// 注意：渐变发光模式下该属性生效
@property (nonatomic, assign) CGFloat lineBloomGradientASPeed;

/// 模糊次数 since 6.6.3
/// 取值范围 [1~10]，默认值为 1
/// 注意：模糊发光模式下该属性生效
@property (nonatomic, assign) int lineBloomBlurTimes;

@end
NS_ASSUME_NONNULL_END
