//
//  BNOpenTTComponentProtocol.h
//  BNOpenTTSComponent
//
//  Created by chenxintao01 on 2023/1/9.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol BNOpenTTComponentDelegate;

@protocol BNOpenTTComponentProtocol <NSObject>
/// TTS SDK鉴权
/// 去https://ai.baidu.com/tech/speech 平台申请
/// - Parameters:
///   - appId: 申请的appId
///   - apiKey: 申请的apiKey
///   - secretKey: 申请的secretKey
///   - completion: 鉴权完成的回调
- (void)authorizeAppId:(NSString*)appId
                apiKey:(NSString*)apiKey
             secretKey:(NSString*)secretKey
            completion:(void (^)(BOOL))completion;

@end

NS_ASSUME_NONNULL_END
