//
//  BMKGeocodeBatchSearch.h
//  BaiduMapAPI_Search
//
//  Created by Baidu on 2025/2/26.
//  Copyright © 2025 Baidu. All rights reserved.
//

#import "BMKSearchBase.h"
#import "BMKGeocodeSearchOption.h"
#import "BMKGeocodeSearchResult.h"

NS_ASSUME_NONNULL_BEGIN
@protocol BMKGeoCodeBatchSearchDelegate;
/// geo batch 检索服务
@interface BMKGeoCodeBatchSearch : BMKSearchBase
/// geo batch 检索模块的Delegate
@property (nonatomic, weak) id<BMKGeoCodeBatchSearchDelegate> delegate;

/// 根据批量地理坐标获取地址信息
/// 异步函数，返回结果在 BMKGeoCodeBatchSearchDelegate 的 onGetReverseGeoCodeBatchResult 通知
/// @param reverseGeoCodeOptions 反geo batch 检索信息类数组（最大20）
/// @return 成功返回YES，否则返回NO
- (BOOL)reverseGeoCodeBatch:(NSArray<BMKReverseGeoCodeSearchOption *> *)reverseGeoCodeOptions;
@end

/// 检索delegate，用于获取检索结果
@protocol BMKGeoCodeBatchSearchDelegate<NSObject>
@optional

/// 返回反地理编码检索结果
/// @param searcher 检索对象
/// @param result 检索结果数组（与reverseGeoCodeOptions顺序一致）
/// @param errorCode 错误号，@see BMKSearchErrorCode
- (void)onGetReverseGeoCodeBatchResult:(BMKGeoCodeBatchSearch *)searcher
                                result:(NSArray<BMKReverseGeoCodeBatchSearchResult *> *)result
                             errorCode:(BMKSearchErrorCode)errorCode;

@end
NS_ASSUME_NONNULL_END
