//
//  BMKIconMarker.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/11.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import "BMKBaseMarker.h"
#import "BMKDrawableResource.h"

NS_ASSUME_NONNULL_BEGIN
/// marker动画类型， since 6.5.4 / 7.5.4
typedef enum : NSUInteger {
    BMKMarkerAnimateNone,    ///< 无动画
    BMKMarkerAnimateDrop,   ///< 从天上掉下
    BMKMarkerAnimateGrow,  ///< 从地面生长
    BMKMarkerAnimateJump   ///< 跳动
} BMKMarkerAnimateType;

@interface BMKIconMarker : BMKBaseMarker
/// 图片资源，必传， since 6.6.4 大量相同图片Marker绘制建议替换为bitmapResource
@property (nonatomic, strong) UIImage *icon;
/// 纹理资源，大量绘制相同图片创建一个纹理资源共用，必传， since 6.6.4
@property (nonatomic, strong) BMKBitmapResource *bitmapResource;
/// 图片混合颜色，可选
@property (nonatomic, strong) UIColor *color;
/// 动画类型，默认BMKMarkerAnimateNone 无动画
@property (nonatomic, assign) BMKMarkerAnimateType animationType;

/// 多帧图片资源组,多张图片，依次播放,默认interval:160ms Repeat次数默认:100
@property (nonatomic, strong) NSArray<UIImage *> *icons;
/// 多帧图片资源组,多张图片，依次播放，大量绘制相同多帧图片创建一组纹理资源共用，必传， since 6.6.4
@property (nonatomic, strong) BMKFrameResource *frameResource;

/// git资源组，大量绘制相同git创建一个git纹理资源共用，必传， since 6.6.4
@property (nonatomic, strong) BMKGifResource *gifResource;

///  初始化多张图片资源
/// @param icons 图片资源集合
/// @param interval 轮换图片资源的时间间隔，最小20ms
/// @param repeatCnt Repeat次数，最大100
- (void)setIcons:(NSArray<UIImage *> *)icons interval:(int)interval repeatCnt:(int)repeatCnt;
@end

NS_ASSUME_NONNULL_END
