//
//  BMKDrawableResource.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/12/27.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@interface BMKDrawableResource : NSObject

@end

@interface BMKBitmapResource : BMKDrawableResource

/// 初始化图片资源
/// @param image 图片
- (instancetype)initWithImage:(UIImage *)image dpiScale:(BOOL)scale;

/// 初始化图片资源
/// @param rgbaPixels 像素
/// @param width 图片宽度
/// @param height 图片高度
- (instancetype)initWithPixelData:(Byte *)rgbaPixels imgWidth:(int)width imgHeight:(int)height dpiScale:(BOOL)scale;

/// 初始化图片资源
/// @param data 图片文件的字节
- (instancetype)initWithImageData:(NSData *)data dpiScale:(BOOL)scale;

/// 初始化「.9」图片资源
/// @param data 图片文件的字节
- (instancetype)initWith9PatchData:(NSData *)data dpiScale:(BOOL)scale;

/// 初始化图片资源
/// @param image 背景图片
/// @param capInsets 可缩放区域
- (instancetype)initWithImage:(UIImage *)image capInsets:(UIEdgeInsets)capInsets dpiScale:(BOOL)scale;

/// 初始化图片资源
/// @param image 背景图片
/// @param scalex 可缩放的X区域 (x1,x2) or (x1,x2,x3,x4)
/// @param scaley 可缩放的Y区域 (y1,y2) or (y1,y2,y3,y4)
/// @param area 「.9」的内容区域 (x1,x2,y1,y2)
- (instancetype)initWithImage:(UIImage *)image scaleX:(NSArray *)scalex
                       scaleY:(NSArray *)scaley fillArea:(UIEdgeInsets)area dpiScale:(BOOL)scale;

/// 初始化图片资源
/// @param data 背景图片文件的字节
/// @param scalex 可缩放的X区域 (x1,x2) or (x1,x2,x3,x4)
/// @param scaley 可缩放的Y区域 (y1,y2) or (y1,y2,y3,y4)
/// @param area 「.9」的内容区域 (x1,x2,y1,y2)
/// @param scale 使用原始图片的字节流，一般需要设置为YES
- (instancetype)initWithData:(NSData *)data scaleX:(NSArray *)scalex
                      scaleY:(NSArray *)scaley fillArea:(NSArray *)area dpiScale:(BOOL)scale;

@end

/// 多张图片，依次播放
@interface BMKFrameResource : BMKDrawableResource

///  初始化多张图片资源
/// @param bitmapResources 图片资源集合
/// @param interval 轮换图片资源的时间间隔
- (instancetype)initWithBitmapResources:(NSArray<BMKBitmapResource *> *)bitmapResources interval:(int)interval;

///  初始化多张图片资源
/// @param bitmapResources 图片资源集合
/// @param interval 轮换图片资源的时间间隔
/// @param repeatCnt Repeat次数
- (instancetype)initWithBitmapResources:(NSArray<BMKBitmapResource *> *)bitmapResources interval:(int)interval repeatCnt:(int)repeatCnt;

///  初始化多张图片资源
/// @param bitmapResources 图片资源集合
/// @param intervals 轮换图片资源的时间间隔
- (instancetype)initWithBitmapResources:(NSArray<BMKBitmapResource *> *)bitmapResources intervals:(NSArray *)intervals;

///  初始化多张图片资源
/// @param bitmapResources 图片资源集合
/// @param intervals 轮换图片资源的时间间隔
/// @param repeatCnt Repeat次数
- (instancetype)initWithBitmapResources:(NSArray<BMKBitmapResource *> *)bitmapResources intervals:(NSArray *)intervals repeatCnt:(int)repeatCnt;

@end

/// GIF的多张图片，依次播放
@interface BMKGifResource : BMKDrawableResource

///  初始化GIF图片资源
/// @param gifData GIF图片资源数据
- (instancetype)initWithGifData:(NSData *)gifData;

- (instancetype)initWithGifData:(NSData *)gifData repeatCount:(int)repeatCount;
@end

NS_ASSUME_NONNULL_END
