//
//  BMKBaseMarkerView.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/11.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import "BMKGeometryView.h"
#import "BMKBaseMarker.h"
NS_ASSUME_NONNULL_BEGIN

@interface BMKBaseMarkerView : BMKGeometryView
/// 该View对应的marker覆盖物
@property (nonatomic, readonly) BMKBaseMarker *marker;
/// 是否可点击，默认YES
@property (assign, nonatomic) BOOL isClickable;
/// 是否可长按拖拽移动，默认NO。且isClickable为YES时生效。
@property (nonatomic, assign, getter=isDraggable) BOOL draggable;


/// 根据指定marker覆盖物生成对应的View
/// @param marker 指定的文字覆盖物
/// @return 生成的View
- (nullable instancetype)initWithMarker:(BMKBaseMarker *)marker;
@end

NS_ASSUME_NONNULL_END
