//
//  BMKBaseMarker.h
//  MapComponent
//
//  Created by zhaoxiangru on 2024/3/11.
//  Copyright © 2024 Baidu. All rights reserved.
//

#import "BMKShape.h"
#import "BMKOverlay.h"
#import "BMKRichView.h"
#import "BMKBaseUIView.h"
#import "BMKMapAnimation.h"
#import "BMKCommonDef.h"
NS_ASSUME_NONNULL_BEGIN

@interface BMKBaseMarker : BMKShape <BMKOverlay>
{
@package
    CLLocationCoordinate2D _coordinate;
    BMKMapRect _boundingMapRect;
}
/// marker的经纬度坐标
@property (nonatomic, assign) CLLocationCoordinate2D coordinate;
/// anchor
@property (nonatomic, assign) float anchorX;
@property (nonatomic, assign) float anchorY;
/// 偏离anchor多少point（屏幕坐标系，向左「-」、向右「+」),默认0
@property (nonatomic, assign) int   offsetX;
/// 偏离anchor多少point（屏幕坐标系，向上「-」、向下「+」),默认0
@property (nonatomic, assign) int   offsetY;
/// 外部设置Marker旋转角度，绕Z轴旋转角度,默认0
@property (nonatomic, assign) float rotate;
/// Marker旋转角度，起作用的方式，默认：BMKRotateFreeze （BMKRotateAnmination | BMKRotateScreenUpper | BMKRotateFlipNo），只有设置包含BMKRotateItem时外部设置的rotate属性才会起作用；设置多个用｜符号；部分设置只能二选一，请参考BMKRotateFeature注释说明
@property (nonatomic, assign) NSUInteger rotateFeature;
/// X轴缩放比例,默认1
@property (nonatomic, assign) float scaleX;
/// Y轴缩放比例,默认1
@property (nonatomic, assign) float scaleY;
/// 是否透视，地图有俯仰角时的远小近大效果,默认NO
@property (nonatomic, assign) BOOL perspective;
/// 固定到屏幕XY坐标，单位point,默认（00）
@property (nonatomic, assign) CGPoint fixXY;
/// Marker跟随地图变化的旋转轴，默认：BMKFollowMapRotateAxisNone不跟随；设置多个用｜符号，如同时跟随地图旋转和俯仰角(BMKFollowMapRotateAxisPitch | BMKFollowMapRotateAxisYaw)
@property (nonatomic, assign) NSUInteger followMapRotateAxis;
/// 碰撞检测类型，默认BMKCollisionNotCollide；不参与碰撞；注意，动画过程中暂时不支持检测
@property (nonatomic, assign) BMKCollisionBehavior collisionBehavior;
/// 碰撞优先级，值越大越不容易被碰掉,默认0
@property (nonatomic, assign) int      collisionPriority;

/// 开启碰撞检测，默认NO，关闭。对齐安卓，兼容旧接口，建议使用collisionBehavior，对应BMKCollisionWithInner，V6.6.3以后支持
@property (nonatomic, assign) BOOL isOpenCollisionDetection;
/// 开启碰撞检测时，是否强制展示，默认NO。对齐安卓，兼容旧接口，建议使用collisionBehavior，对应BMKCollisionInnerAndBasePoi，V6.6.3以后支持
@property (nonatomic, assign) BOOL isForceDisplay;
/// 是否开启与底图POI的碰撞检测，默认NO。对齐安卓，兼容旧接口，建议使用collisionBehavior，对应BMKCollisionAlwaysShow，V6.6.3以后支持
@property (nonatomic, assign) BOOL isOpenCollisionDetectionWithMapPOI;

/// 动画，跟随模式,默认BMKAnimationTrackXY
@property (nonatomic, assign) NSUInteger trackBy;
/// 动画,除BMKMapTrackAnimation，其他动画默认添加后自动start，使用BMKMapAnimation子类实现动画，支持BMKMapAlphaAnimation，BMKMapRotateAnimation，BMKMapScaleAnimation，BMKMapTranslateAnimation，BMKMapTrackAnimation,BMKMapAnimationSet ,since 6.6.3
@property (nonatomic, strong, nullable) BMKMapAnimation *animation;
// 可见性
@property (nonatomic, assign) BMKVisibility   visibility;
// 透明度，范围 [0, 1.0]，默认1.0
@property (nonatomic, assign) float           opacity;
// zindex,默认-1,不起作用
@property (nonatomic, assign) NSInteger       zIndex;

///** Add BMKRichView to this Marker. */
- (BOOL)addRichView:(nonnull BMKRichView *)view;
///** Remove BMKRichView from this Marker. */
- (BOOL)removeRichView:(nonnull BMKRichView *)view;
// 显示最大最小地图等级，默认from:4 to:22，范围[4,22]
- (BOOL)setShowLevel:(int)from toLevel:(int)to;
@end

NS_ASSUME_NONNULL_END
